<?php
// success.php
session_start();

// Get booking data from session
$bookingData = $_SESSION['booking_data'] ?? null;

// Clear the session data after displaying
unset($_SESSION['booking_data']);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Booking Successful - CEDI Conference Centre</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #0056b3;
            --secondary: #f8f9fa;
            --success: #28a745;
            --light: #fff;
            --text: #333;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .success-container {
            background: white;
            border-radius: 20px;
            padding: 50px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.2);
            text-align: center;
            max-width: 600px;
            width: 100%;
            position: relative;
            overflow: hidden;
        }

        .success-container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 5px;
            background: linear-gradient(90deg, var(--success), var(--primary));
        }

        .success-icon {
            width: 100px;
            height: 100px;
            background: var(--success);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 30px;
            animation: bounce 1s ease-in-out;
        }

        .success-icon i {
            font-size: 3rem;
            color: white;
        }

        @keyframes bounce {
            0%, 20%, 50%, 80%, 100% {transform: translateY(0);}
            40% {transform: translateY(-10px);}
            60% {transform: translateY(-5px);}
        }

        h1 {
            color: var(--success);
            font-size: 2.5rem;
            margin-bottom: 20px;
        }

        .subtitle {
            color: #666;
            font-size: 1.2rem;
            margin-bottom: 30px;
            line-height: 1.6;
        }

        .booking-details {
            background: var(--secondary);
            border-radius: 15px;
            padding: 30px;
            margin: 30px 0;
            text-align: left;
            border-left: 5px solid var(--primary);
        }

        .detail-item {
            display: flex;
            justify-content: space-between;
            margin-bottom: 15px;
            padding-bottom: 15px;
            border-bottom: 1px solid #dee2e6;
        }

        .detail-item:last-child {
            margin-bottom: 0;
            padding-bottom: 0;
            border-bottom: none;
        }

        .detail-label {
            font-weight: 600;
            color: #555;
        }

        .detail-value {
            color: var(--text);
            text-align: right;
        }

        .next-steps {
            background: #e7f3ff;
            border-radius: 15px;
            padding: 25px;
            margin: 30px 0;
            text-align: left;
        }

        .next-steps h3 {
            color: var(--primary);
            margin-bottom: 15px;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .next-steps ul {
            list-style: none;
            padding-left: 0;
        }

        .next-steps li {
            margin-bottom: 12px;
            padding-left: 30px;
            position: relative;
        }

        .next-steps li::before {
            content: '✓';
            position: absolute;
            left: 0;
            color: var(--success);
            font-weight: bold;
        }

        .contact-info {
            background: var(--secondary);
            border-radius: 15px;
            padding: 25px;
            margin: 30px 0;
        }

        .contact-info h3 {
            color: var(--primary);
            margin-bottom: 15px;
        }

        .contact-methods {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 15px;
            margin-top: 20px;
        }

        .contact-method {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 15px;
            background: white;
            border-radius: 10px;
            transition: transform 0.3s ease;
        }

        .contact-method:hover {
            transform: translateY(-2px);
        }

        .contact-method i {
            font-size: 1.5rem;
            color: var(--primary);
        }

        .action-buttons {
            display: flex;
            gap: 15px;
            justify-content: center;
            margin-top: 30px;
            flex-wrap: wrap;
        }

        .btn {
            padding: 15px 30px;
            border: none;
            border-radius: 10px;
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 10px;
        }

        .btn-primary {
            background: var(--primary);
            color: white;
        }

        .btn-primary:hover {
            background: #004494;
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 86, 179, 0.3);
        }

        .btn-outline {
            background: transparent;
            color: var(--primary);
            border: 2px solid var(--primary);
        }

        .btn-outline:hover {
            background: var(--primary);
            color: white;
            transform: translateY(-2px);
        }

        @media (max-width: 768px) {
            .success-container {
                padding: 30px 20px;
            }
            
            h1 {
                font-size: 2rem;
            }
            
            .action-buttons {
                flex-direction: column;
            }
            
            .btn {
                width: 100%;
                justify-content: center;
            }
        }
    </style>
</head>
<body>
    <div class="success-container">
        <div class="success-icon">
            <i class="fas fa-check"></i>
        </div>
        
        <h1>Booking Request Submitted!</h1>
        <p class="subtitle">Thank you for choosing CEDI Conference Centre. Your request has been received and is being processed.</p>

        <?php if ($bookingData): ?>
        <div class="booking-details">
            <h3><i class="fas fa-clipboard-check"></i> Booking Summary</h3>
            <div class="detail-item">
                <span class="detail-label">Organization:</span>
                <span class="detail-value"><?php echo htmlspecialchars($bookingData['organization']); ?></span>
            </div>
            <div class="detail-item">
                <span class="detail-label">Event Name:</span>
                <span class="detail-value"><?php echo htmlspecialchars($bookingData['eventName']); ?></span>
            </div>
            <div class="detail-item">
                <span class="detail-label">Representative:</span>
                <span class="detail-value"><?php echo htmlspecialchars($bookingData['representativeName']); ?></span>
            </div>
            <div class="detail-item">
                <span class="detail-label">Event Dates:</span>
                <span class="detail-value"><?php echo htmlspecialchars($bookingData['eventDates']); ?></span>
            </div>
            <div class="detail-item">
                <span class="detail-label">Contact Email:</span>
                <span class="detail-value"><?php echo htmlspecialchars($bookingData['email']); ?></span>
            </div>
            <?php if (isset($bookingData['booking_id'])): ?>
            <div class="detail-item">
                <span class="detail-label">Reference Number:</span>
                <span class="detail-value" style="color: var(--primary); font-weight: bold;">
                    #<?php echo htmlspecialchars($bookingData['booking_id']); ?>
                </span>
            </div>
            <?php endif; ?>
        </div>
        <?php endif; ?>

        <div class="next-steps">
            <h3><i class="fas fa-list-alt"></i> What Happens Next?</h3>
            <ul>
                <li>You will receive a confirmation email shortly</li>
                <li>Our team will review your request within 24-48 hours</li>
                <li>We will contact you to discuss details and confirm availability</li>
                <li>Final confirmation and payment details will be provided</li>
            </ul>
        </div>

        <div class="contact-info">
            <h3><i class="fas fa-headset"></i> Need Immediate Assistance?</h3>
            <p>Feel free to contact us directly:</p>
            <div class="contact-methods">
                <div class="contact-method">
                    <i class="fas fa-phone"></i>
                    <div>
                        <strong>Call Us</strong>
                        <div>050 668 6685</div>
                    </div>
                </div>
                <div class="contact-method">
                    <i class="fab fa-whatsapp"></i>
                    <div>
                        <strong>WhatsApp</strong>
                        <div>050 668 6685</div>
                    </div>
                </div>
                <div class="contact-method">
                    <i class="fas fa-envelope"></i>
                    <div>
                        <strong>Email</strong>
                        <div>ccc.econ@ug.edu.gh</div>
                    </div>
                </div>
            </div>
        </div>

        <div class="action-buttons">
            <a href="index.html" class="btn btn-primary">
                <i class="fas fa-home"></i> Back to Home
            </a>
            <a href="javascript:window.print()" class="btn btn-outline">
                <i class="fas fa-print"></i> Print Confirmation
            </a>
        </div>

        <p style="margin-top: 30px; color: #666; font-size: 0.9rem;">
            <i class="fas fa-clock"></i> Page will automatically redirect to home in <span id="countdown">60</span> seconds
        </p>
    </div>

    <script>
        // Countdown timer for automatic redirect
        let seconds = 60;
        const countdownElement = document.getElementById('countdown');
        
        const countdown = setInterval(() => {
            seconds--;
            countdownElement.textContent = seconds;
            
            if (seconds <= 0) {
                clearInterval(countdown);
                window.location.href = 'index.html';
            }
        }, 1000);

        // Add confirmation number to browser history
        if (window.history && window.history.replaceState) {
            window.history.replaceState(null, null, '?success=1');
        }
    </script>
</body>
</html>