<?php
// forgot_password.php
require_once 'config.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit;
}

$username = trim($_POST['username'] ?? '');
$email = trim($_POST['email'] ?? '');

if (empty($username) || empty($email)) {
    echo json_encode(['success' => false, 'message' => 'Please fill in all fields']);
    exit;
}

try {
    // Check if admin exists with matching username and email
    $stmt = $pdo->prepare("SELECT id, username, email, full_name FROM admins WHERE username = ? AND email = ? AND is_active = 1");
    $stmt->execute([$username, $email]);
    $admin = $stmt->fetch();

    if (!$admin) {
        echo json_encode(['success' => false, 'message' => 'No admin found with matching username and email']);
        exit;
    }

    // Generate a new random password
    $new_password = generateRandomPassword();
    $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);

    // Update the password in database
    $update_stmt = $pdo->prepare("UPDATE admins SET password_hash = ? WHERE id = ?");
    $update_stmt->execute([$hashed_password, $admin['id']]);

    // In a real application, you would send an email here
    // For now, we'll just return the new password (in production, remove this!)
    
    echo json_encode([
        'success' => true, 
        'message' => 'Password reset successfully',
        'new_password' => $new_password, // Remove this in production!
        'email' => $admin['email']
    ]);

} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}

function generateRandomPassword($length = 12) {
    $chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()';
    $password = '';
    for ($i = 0; $i < $length; $i++) {
        $password .= $chars[random_int(0, strlen($chars) - 1)];
    }
    return $password;
}
?>