<?php
// debug_super_admin.php
session_start();
require_once 'config.php';

echo "<h2>🔍 Debugging Super Admin Access</h2>";

// Check session data
echo "<h3>Session Data:</h3>";
echo "admin_id: " . ($_SESSION['admin_id'] ?? 'NOT SET') . "<br>";
echo "admin_username: " . ($_SESSION['admin_username'] ?? 'NOT SET') . "<br>";
echo "admin_role: " . ($_SESSION['admin_role'] ?? 'NOT SET') . "<br>";
echo "admin_logged_in: " . ($_SESSION['admin_logged_in'] ?? 'NOT SET') . "<br>";

// Check functions
echo "<h3>Function Results:</h3>";
echo "isAdminLoggedIn(): " . (isAdminLoggedIn() ? 'TRUE' : 'FALSE') . "<br>";
echo "isSuperAdmin(): " . (isSuperAdmin() ? 'TRUE' : 'FALSE') . "<br>";

// Check database directly
echo "<h3>Database Check:</h3>";
try {
    if (isset($_SESSION['admin_id'])) {
        $stmt = $pdo->prepare("SELECT id, username, role FROM admins WHERE id = ?");
        $stmt->execute([$_SESSION['admin_id']]);
        $admin = $stmt->fetch();
        
        if ($admin) {
            echo "Database record found:<br>";
            echo "ID: " . $admin['id'] . "<br>";
            echo "Username: " . $admin['username'] . "<br>";
            echo "Role: " . $admin['role'] . "<br>";
            echo "Session role vs Database role: '" . ($_SESSION['admin_role'] ?? 'NOT SET') . "' vs '" . $admin['role'] . "'<br>";
        } else {
            echo "❌ No admin found with ID: " . $_SESSION['admin_id'] . "<br>";
        }
    } else {
        echo "❌ No admin_id in session<br>";
    }
} catch (Exception $e) {
    echo "❌ Database error: " . $e->getMessage() . "<br>";
}

// Test links
echo "<h3>Test Links:</h3>";
echo "<a href='admin_management.php'>Test Admin Management</a><br>";
echo "<a href='create_admin.php'>Test Create Admin</a><br>";
echo "<a href='admin_dashboard.php'>Test Dashboard</a><br>";

// Force super admin for testing
echo "<h3>Force Super Admin (for testing):</h3>";
echo "<form method='POST'>";
echo "<input type='submit' name='force_super' value='Force Set Session as Super Admin'>";
echo "</form>";

if (isset($_POST['force_super'])) {
    $_SESSION['admin_role'] = 'super_admin';
    echo "✅ Session role forced to 'super_admin'<br>";
    echo "<a href='admin_management.php'>Now test Admin Management</a><br>";
}
?>