<?php
// admin_login.php - WITH FORGOT PASSWORD
session_start();
require_once 'config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    // Use the database authentication from config.php
    if (adminLogin($username, $password)) {
        $adminInfo = getAdminInfo();
        
        // Redirect based on role
        if ($adminInfo['role'] === 'super_admin') {
            header('Location: admin_management.php');
        } else {
            header('Location: admin_dashboard.php');
        }
        exit;
    } else {
        $error = 'Invalid username or password';
    }
}

if (isAdminLoggedIn()) {
    $adminInfo = getAdminInfo();
    if ($adminInfo['role'] === 'super_admin') {
        header('Location: admin_management.php');
    } else {
        header('Location: admin_dashboard.php');
    }
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login - CEDI Conference Centre</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .login-container {
            background: white;
            border-radius: 15px;
            padding: 40px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            width: 100%;
            max-width: 400px;
            text-align: center;
        }

        .logo {
            width: 80px;
            height: 80px;
            background: #0056b3;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
        }

        .logo i {
            font-size: 2.5rem;
            color: white;
        }

        h1 {
            color: #0056b3;
            margin-bottom: 10px;
            font-size: 1.8rem;
        }

        .subtitle {
            color: #666;
            margin-bottom: 30px;
        }

        .form-group {
            margin-bottom: 20px;
            text-align: left;
        }

        label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #555;
        }

        .input-with-icon {
            position: relative;
        }

        .input-with-icon i {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: #6c757d;
        }

        .input-with-icon input {
            width: 100%;
            padding: 15px 15px 15px 45px;
            border: 2px solid #dee2e6;
            border-radius: 8px;
            font-size: 1rem;
            transition: all 0.3s ease;
        }

        .input-with-icon input:focus {
            outline: none;
            border-color: #0056b3;
            box-shadow: 0 0 0 3px rgba(0, 86, 179, 0.1);
        }

        .btn {
            width: 100%;
            padding: 15px;
            background: #0056b3;
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }

        .btn:hover {
            background: #004494;
            transform: translateY(-2px);
        }

        .btn-forgot {
            background: transparent;
            color: #0056b3;
            border: none;
            text-decoration: underline;
            cursor: pointer;
            font-size: 0.9rem;
            margin-top: 10px;
            display: inline-flex;
            align-items: center;
            gap: 5px;
        }

        .btn-forgot:hover {
            color: #004494;
        }

        .error {
            background: #f8d7da;
            color: #721c24;
            padding: 12px;
            border-radius: 6px;
            margin-bottom: 20px;
            border-left: 4px solid #dc3545;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .success {
            background: #d4edda;
            color: #155724;
            padding: 12px;
            border-radius: 6px;
            margin-bottom: 20px;
            border-left: 4px solid #28a745;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .demo-credentials {
            background: #e7f3ff;
            padding: 15px;
            border-radius: 8px;
            margin-top: 20px;
            font-size: 0.9rem;
            color: #0056b3;
            text-align: left;
        }

        .role-info {
            background: #fff3cd;
            padding: 12px;
            border-radius: 6px;
            margin-top: 15px;
            font-size: 0.8rem;
            color: #856404;
            text-align: left;
            border-left: 4px solid #ffc107;
        }

        .forgot-link {
            text-align: center;
            margin-top: 15px;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="logo">
            <i class="fas fa-university"></i>
        </div>
        <h1>Admin Login</h1>
        <p class="subtitle">CEDI Conference Centre Dashboard</p>

        <?php if (isset($error)): ?>
            <div class="error">
                <i class="fas fa-exclamation-triangle"></i> <?php echo $error; ?>
            </div>
        <?php endif; ?>

        <?php if (isset($_GET['reset']) && $_GET['reset'] === 'success'): ?>
            <div class="success">
                <i class="fas fa-check-circle"></i> Password reset successfully! New password sent to your email.
            </div>
        <?php endif; ?>

        <form method="POST" action="">
            <div class="form-group">
                <label for="username">Username</label>
                <div class="input-with-icon">
                    <i class="fas fa-user"></i>
                    <input type="text" id="username" name="username" required placeholder="Enter username">
                </div>
            </div>

            <div class="form-group">
                <label for="password">Password</label>
                <div class="input-with-icon">
                    <i class="fas fa-lock"></i>
                    <input type="password" id="password" name="password" required placeholder="Enter password">
                </div>
            </div>

            <button type="submit" class="btn">
                <i class="fas fa-sign-in-alt"></i> Login
            </button>

            <div class="forgot-link">
                <button type="button" class="btn-forgot" onclick="showForgotPassword()">
                    <i class="fas fa-key"></i> Forgot Password?
                </button>
            </div>
        </form>

        <div class="demo-credentials">
            <strong>Default Credentials:</strong><br>
            Username: admin<br>
            Password: admin123
        </div>

        <div class="role-info">
            <strong>Role-based Access:</strong><br>
            • Super Admins: Full system access<br>
            • Regular Admins: Booking management only
        </div>
    </div>

    <!-- Forgot Password Modal -->
    <div id="forgotModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 1000; align-items: center; justify-content: center;">
        <div style="background: white; border-radius: 15px; padding: 30px; width: 90%; max-width: 400px; text-align: center;">
            <h3 style="color: #0056b3; margin-bottom: 20px;">
                <i class="fas fa-key"></i> Reset Password
            </h3>
            <form id="forgotForm" method="POST" action="forgot_password.php">
                <div class="form-group">
                    <label for="reset_username">Enter your username</label>
                    <div class="input-with-icon">
                        <i class="fas fa-user"></i>
                        <input type="text" id="reset_username" name="username" required placeholder="Enter your username">
                    </div>
                </div>
                <div class="form-group">
                    <label for="reset_email">Enter your email</label>
                    <div class="input-with-icon">
                        <i class="fas fa-envelope"></i>
                        <input type="email" id="reset_email" name="email" required placeholder="Enter your email">
                    </div>
                </div>
                <div style="display: flex; gap: 10px; margin-top: 20px;">
                    <button type="submit" class="btn" style="flex: 1;">
                        <i class="fas fa-paper-plane"></i> Reset Password
                    </button>
                    <button type="button" class="btn" onclick="hideForgotPassword()" style="background: #6c757d; flex: 1;">
                        <i class="fas fa-times"></i> Cancel
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script>
        function showForgotPassword() {
            document.getElementById('forgotModal').style.display = 'flex';
        }

        function hideForgotPassword() {
            document.getElementById('forgotModal').style.display = 'none';
        }

        // Close modal when clicking outside
        document.getElementById('forgotModal').addEventListener('click', function(e) {
            if (e.target === this) {
                hideForgotPassword();
            }
        });

        // Handle forgot password form submission
        document.getElementById('forgotForm').addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(this);
            
            fetch('forgot_password.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    alert('Password reset successfully! Check your email for the new password.');
                    hideForgotPassword();
                } else {
                    alert('Error: ' + data.message);
                }
            })
            .catch(error => {
                alert('An error occurred. Please try again.');
                console.error('Error:', error);
            });
        });
    </script>
</body>
</html>